<?php
/**
 * @copyright ICZ Corporation (http://www.icz.co.jp/)
 * @license See the LICENCE file
 * @author <matcha@icz.co.jp>
 * @version $Id$
 */
require('simple_coverpage.php');

class QUOTEPDF extends SIMPLE_COVERPAGEPDF
{

	//ヘッダ
  function Header()
    {
	}

	function main($_param, $_county,$_direction,$_items,$_pages){
		//社判
		if($_param['Company']['SEAL'] && $_param['Quote']['CMP_SEAL_FLG']){
			$this->Image($_param['Company']['SEAL_IMAGE'],160, 40, 25,25,'PNG');
		}

		//社員判
		if($_param['Quote']['CHR_ID'] && $_param['Charge']['SEAL'] && $_param['Quote']['CHR_SEAL_FLG']){
			$this->Image($_param['Charge']['SEAL_IMAGE'],171, 67, 18,18);
		}

		$this->SetMargins(0, 0, 0);
		$this->SetAutoPageBreak(true, 1.0);



		switch($_param['Company']['COLOR']) {
			//黒
			case 0:
				$line_color = array('R' => 136, 'G' => 136, 'B' => 136);
				$column_color = array('R' => 204, 'G' => 204, 'B' => 204);
				$row_color = array('R' => 238, 'G' => 238, 'B' => 238);
				break;

			//青
			case 1:
				$line_color = array('R' => 0, 'G' => 99, 'B' => 244);
				$column_color = array('R' => 135, 'G' => 179, 'B' => 230);
				$row_color = array('R' => 212, 'G' => 237, 'B' => 255);
				break;

			//赤
			case 2:
				$line_color = array('R' => 255, 'G' => 89, 'B' => 158);
				$column_color = array('R' => 255, 'G' => 181, 'B' => 184);
				$row_color = array('R' => 255, 'G' => 240, 'B' => 255);
				break;

			//緑
			case 3:
				$line_color = array('R' => 0, 'G' => 88, 'B' =>52);
				$column_color = array('R' => 160, 'G' => 217, 'B' => 168);
				$row_color = array('R' => 223, 'G' => 242, 'B' => 226);
				break;
		}

		$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
		$this->SetFont(MINCHO,'B',16);
		$this->SetXY(18, 17);

		$str = "御 見 積 書";
		$str = $this->conv($str);
		$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
		$this->Cell( 172, 10, $str, 1, 1, 'C',1);
		$this->SetTextColor(0);

		//No.
		$this->SetXY(162, 29);
		$this->SetFont(MINCHO,'',9);
		$str = 'No.';
		$str = $this->conv($str);
		$this->Write(5, $str);

		//見積書番号
		$this->SetXY(168, 29);
		$this->SetFont(MINCHO,'',9);
		$str = $_param['Quote']['NO'];
		$str = $this->conv($str);
		$this->Cell( 23, 5, $str, 0, 1, 'R');

		//日付
		$this->SetXY(170,33);
		$this->SetFont(MINCHO,'',9);
		$str = substr($_param['Quote']['ISSUE_DATE'],0,4)."年".substr($_param['Quote']['ISSUE_DATE'],5,2)."月".substr($_param['Quote']['ISSUE_DATE'],8,2)."日";
		$str = $this->conv($str);
		$this->Cell( 21, 5, $str, 0, 1, 'R');

			//部署・顧客担当者名
		if(isset($_param['CustomerCharge']['UNIT'])&&isset($_param['CustomerCharge']['CHARGE_NAME'])) {
			if(mb_strlen($_param['Customer']['NAME']) > mb_strlen($_param['CustomerCharge']['UNIT']."　".$_param['CustomerCharge']['CHARGE_NAME'])) {
				$font_size = $this->customer_font(mb_strlen($_param['Customer']['NAME']));
			}else {
				$font_size = $this->customer_font(mb_strlen($_param['CustomerCharge']['UNIT']."　".$_param['CustomerCharge']['CHARGE_NAME']));
			}

			//顧客名
			$this->SetXY(18, 30);
			$this->SetFont(MINCHO,'',$font_size);
			$str = $_param['Customer']['NAME'];
			$str = $this->conv($str);
			$this->Cell( 105, 4, $str, 'B');

			//部署
			$this->SetXY(18, 36);
			$this->SetFont(MINCHO,'',$font_size);

			$str = "";
			if($_param['CustomerCharge']['UNIT']) {
				$str .= $_param['CustomerCharge']['UNIT']."　";
			}
			$str .=$_param['CustomerCharge']['CHARGE_NAME'];

			switch($_param['Quote']['HONOR_CODE'] ) {
				case 0:
					$str .= '　　御中';
					break;

				case 1:
					$str .= '　　様';
					break;

				case 2:
					$str .= '　　'.$_param['Quote']['HONOR_TITLE'];
					break;
			}

			$str = $this->conv($str);
			$this->Cell( 105, 4, $str, 'B');
		}

		else{


			$this->SetXY(18, 36);
			$this->SetFont(MINCHO,'',$this->customer_font(mb_strlen($_param['Customer']['NAME'])));
			$str = $_param['Customer']['NAME'];

			switch($_param['Quote']['HONOR_CODE'] ) {
				case 0:
					$str .= '　　御中';
					break;

				case 1:
					$str .= '　　様';
					break;

				case 2:
					$str .= '　　'.$_param['Quote']['HONOR_TITLE'];
					break;
			}


			$str = $this->conv($str);
			$this->Cell( 105, 4, $str, 'B');
		}


		//件名
		$this->SetXY(18, 47.5);
		$this->SetFont(MINCHO,'',10);
		$this->SetDrawColor($column_color['R'],$column_color['G'],$column_color['B']);
		$str = "件名:".$_param['Quote']['SUBJECT'];
		$str = $this->conv($str);
		$this->Cell( 90, 4.5, $str, 'B', 1, 'L');

		$temp_y = 55.5;
		if(!empty($_param['Quote']['DEADLINE'])){
			//納入期限
			$this->SetXY(18, $temp_y);
			$this->SetFont(MINCHO,'',9);
			$str = "納入期限:".$_param['Quote']['DEADLINE'];
			$str = $this->conv($str);
			$this->Cell( 80, 4.5, $str, 'B', 1, 'L');
			$temp_y = $temp_y + 6;
		}
		if(!empty($_param['Quote']['DEAL'])){
			//取引方法
			$this->SetXY(18, $temp_y);
			$this->SetFont(MINCHO,'',9);
			$str = "取引方法:".$_param['Quote']['DEAL'];
			$str = $this->conv($str);
			$this->Cell( 80, 4.5, $str, 'B', 1, 'L');
			$temp_y = $temp_y + 6;
		}
		if(!empty($_param['Quote']['DELIVERY'])){
			//納入場所
			$this->SetXY(18, $temp_y);
			$this->SetFont(MINCHO,'',9);
			$str = "納入場所:".$_param['Quote']['DELIVERY'];
			$str = $this->conv($str);
			$this->Cell( 80, 4.5, $str, 'B', 1, 'L');
			$temp_y = $temp_y + 6;
		}
		if(!empty($_param['Quote']['DUE_DATE'])){
			//有効期限
			$this->SetXY(18, $temp_y);
			$this->SetFont(MINCHO,'',9);
			$str = "有効期限:".$_param['Quote']['DUE_DATE'];
			$str = $this->conv($str);
			$this->Cell( 80, 4.5, $str, 'B', 1, 'L');
		}


		$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
		//自社名
		$this->SetXY(129, 40);
		$this->SetFont(MINCHO,'',9);
		$str = $_param['Company']['NAME'];
		$str = $this->conv($str);
		$this->Write(5, $str);

		//郵便番号
		$this->SetXY(129, 45);
		$this->SetFont(MINCHO,'',9);
		if(isset($_param['Charge']['UNIT']) && isset($_param['Charge']['CHARGE_NAME'])){
			$str  = "";
			if(empty($_param['Charge']['POSTCODE1']) && empty($_param['Charge']['POSTCODE2'])) {

			}else {
				$str  = "〒";
				$str .= $_param['Charge']['POSTCODE1']."-".$_param['Charge']['POSTCODE2'];
			}
		}else{
			$str  = "";

			if(empty($_param['Company']['POSTCODE1']) && empty($_param['Company']['POSTCODE2'])) {

			}else {
				$str  = "〒";
				$str .= $_param['Company']['POSTCODE1']."-".$_param['Company']['POSTCODE2'];
			}
		}
		$str = $this->conv($str);
		$this->Write(5, $str);

		//住所
		$this->SetXY(129, 48.5);
		$this->SetFont(MINCHO,'',9);
		if(isset($_param['Charge']['UNIT']) && isset($_param['Charge']['CHARGE_NAME'])){
			$str = $_param['Charge']['CNT_ID'] ? $_county[$_param['Charge']['CNT_ID']] : "";
			$str .= $_param['Charge']['ADDRESS'];
		}else{
			$str = $_param['Company']['CNT_ID'] ? $_county[$_param['Company']['CNT_ID']] : "";
			$str .= $_param['Company']['ADDRESS'];
		}
		$str = $this->conv($str);
		$this->Write(5, $str);

		//建物名
		$this->SetXY(129, 52);
		$this->SetFont(MINCHO,'',9);
		if(isset($_param['Charge']['UNIT']) && isset($_param['Charge']['CHARGE_NAME'])){
			$str = $_param['Charge']['BUILDING'];
		}else{
			$str = $_param['Company']['BUILDING'];
		}

		$str = $this->conv($str);
		$this->Write(5, $str);


		$this->SetXY(129, 55.5);
		$this->SetFont(MINCHO,'',9);
		if(isset($_param['Charge']['UNIT']) && isset($_param['Charge']['CHARGE_NAME'])){
			$str = "";
			if(empty($_param['Charge']['PHONE_NO1']) && empty($_param['Charge']['PHONE_NO2']) && empty($_param['Charge']['PHONE_NO3'])) {

			}else {
				$str = "TEL ";
				$str .= $_param['Charge']['PHONE_NO1']."-".$_param['Charge']['PHONE_NO2']."-".$_param['Charge']['PHONE_NO3'];
			}

			if($_param['Charge']['FAX_NO1'] && $_param['Charge']['FAX_NO2'] && $_param['Charge']['FAX_NO3']){
				$str .= "　FAX ".$_param['Charge']['FAX_NO1']."-".$_param['Charge']['FAX_NO2']."-".$_param['Charge']['FAX_NO3'];
			}
		}else{
			$str = "";
			if(empty($_param['Company']['PHONE_NO1']) && empty($_param['Company']['PHONE_NO2']) && empty($_param['Company']['PHONE_NO3'])) {

			}else {
				$str = "TEL ";
				$str .= $_param['Company']['PHONE_NO1']."-".$_param['Company']['PHONE_NO2']."-".$_param['Company']['PHONE_NO3'];
			}

			if($_param['Company']['FAX_NO1'] && $_param['Company']['FAX_NO2'] && $_param['Company']['FAX_NO3']) {
				$str .= "　FAX ".$_param['Company']['FAX_NO1']."-".$_param['Company']['FAX_NO2']."-".$_param['Company']['FAX_NO3'];
			}
		}
		$str = $this->conv($str);
		$this->Write(5, $str);


		//部署・自社担当者名
		if(isset($_param['Charge']['UNIT']) && isset($_param['Charge']['CHARGE_NAME'])){
			$this->SetXY(129, 59);
			$this->SetFont(MINCHO,'',9);

			$str = $_param['Charge']['UNIT'].'　'.$_param['Charge']['CHARGE_NAME'];

			$str = $this->conv($str);
			$this->Write(5, $str);
		}

		//印鑑枠
		$this->SetXY(130, 66);
		$this->Cell(20, 20, '', 1, 0, 'C');
		$this->Cell(20, 20, '', 1, 0, 'C');
		$this->Cell(20, 20, '', 1, 0, 'C');



		//合計金額
		$this->SetXY(18, 80);
		$this->SetLineWidth(0.4);
		$this->SetFont(MINCHO,'B',13);
		$str = "合計金額";
		$str = $this->conv($str);
		$this->Cell( 100, 7, $str, 'B', 1, 'L');
		$this->Line(18, 86, 118, 86);
		$this->SetLineWidth(0.2);

		$this->SetXY(18, 80);
		$str = '\\'.number_format($_param['Quote']['TOTAL']).'-';
		$str = $this->conv($str);
		$this->Cell( 100, 7, $str, 0, 1, 'R');
		//単位・円
		$this->SetXY(175, 87);
		$this->SetFont(MINCHO,'',10);
		$str = "単位：円";
		$str = $this->conv($str);
		$this->Write(5, $str);

		//表の幅
		$w_no		=  8;
		$w_code		= 15;
		$w_item		= 73;
		$w_quantity	= 23;
		$w_unit		= 23;
		$w_total	= 30;

		//表の表示
		for($j = 0 ; $j < $_pages; $j++){

			$amount=0;
			$discount_m=0;
			$item_count=0;
			$rows=0;

			//1ページのみの場合
			if($_pages == 1 && $j == 0){
				$page_num = 20;
				$this->SetXY(18, 92);
				$this->SetFont(MINCHO,'B',8);
				$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
				$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
				$this->Cell($w_no, 8, $this->conv('No.'), 'T', 0, 'C',1);
				$this->Cell($w_code, 8, $this->conv('商品コード'), 'T', 0, 'C',1);
				$this->Cell($w_item, 8, $this->conv('品目名'), 'T', 0, 'C',1);
				$this->Cell($w_quantity, 8, $this->conv('数量'), 'T', 0, 'C',1);
				$this->Cell($w_unit, 8, $this->conv('単価'), 'T', 0, 'C',1);
				$this->Cell($w_total, 8, $this->conv('合計'), 'T', 0, 'C',1);
				$this->SetFont(MINCHO,'',8);
				$i = 0;

				$y = 222;

				if(!empty($_param['Quote']['DISCOUNT'])){
					$this->SetXY(123, $y);
					$this->SetFont(MINCHO,'B',8);
					$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
					$this->Cell(28, 6, $this->conv('　割引'), '1', 0, 'L',1);
					$this->SetFont(MINCHO,'',8);
					$this->SetFillColor(0xFF, 0xFF, 0xFF);
					if($_param['Quote']['DISCOUNT_TYPE'] == 0 ){
						$str = $_param['Quote']['DISCOUNT'] ? number_format($_param['Quote']['DISCOUNT'] ) .'%': '0';
					}elseif($_param['Quote']['DISCOUNT_TYPE'] == 1 ){
						$str = $_param['Quote']['DISCOUNT'] ? '▲'.number_format($_param['Quote']['DISCOUNT'] ) : '0';
					}else{
						$str ='';
					}

					$str = $this->conv($str);
					$this->Cell(39, 6, $str, 1, 0, 'R',1);
					$y = $y + 6;
				}
				$this->SetXY(123, $y);
				$this->SetFont(MINCHO,'B',8);
				$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
				$this->Cell(28, 6, $this->conv('　小計'), '1', 0, 'L',1);
				$this->SetFillColor(0xFF, 0xFF, 0xFF);
				$this->SetFont(MINCHO,'',8);
				$str = $_param['Quote']['SUBTOTAL'] ? number_format($_param['Quote']['SUBTOTAL']) : '0';
				$str = $this->conv($str);
				$this->Cell(39, 6, $str, 1, 0, 'R',1);
				$y = $y + 6;

				$this->SetXY(123, $y);
				$this->SetFont(MINCHO,'B',8);
				$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
				$this->Cell(28, 6, $this->conv('　消費税'), '1', 0, 'L',1);
				$this->SetFillColor(0xFF, 0xFF, 0xFF);
				$this->SetFont(MINCHO,'',8);
				$str = $_param['Quote']['SALES_TAX'] ? number_format($_param['Quote']['SALES_TAX']) : '0';
				$str = $this->conv($str);
				$this->Cell(39, 6, $str, 1, 0, 'R',1);
				$y = $y + 6;

				$this->SetXY(123, $y);
				$this->SetFont(MINCHO,'B',8);
				$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
				$this->Cell(28, 6, $this->conv('　合計'), '1', 0, 'L',1);
				$this->SetFillColor(0xFF, 0xFF, 0xFF);
				$this->SetFont(MINCHO,'',8);
				$str = $_param['Quote']['TOTAL'] ? number_format($_param['Quote']['TOTAL']) : '0';
				$str = $this->conv($str);
				$this->Cell(39, 6, $str, 1, 0, 'R',1);
				$y = $y + 4;

				//備考欄
				$this->SetXY(18, $y);
				$this->SetFont(MINCHO,'B',9);
				$str = "備考欄";
				$str = $this->conv($str);
				$this->Write(5, $str);
				$y = $y + 5;


				$this->SetFont(MINCHO,'',9);
				$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
				$this->SetXY(18, $y);
				$str = $_param['Quote']['NOTE'];
				$str = $this->conv($str);
				$this->Cell( 172, 25, '', 1, 1, 'C');
				$this->SetXY(18, $y+1);
				$this->MBMultiCell(172, 4, $str, 0, 'L');
				$this->SetFont(MINCHO,'B',8);

			}

			//2ページ以上の1ページ目
			elseif($_pages > 1 && $j == 0){
				$this->SetXY(18, 92);
				$this->SetFont(MINCHO,'B',8);
				$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
				$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
				$this->Cell($w_no, 8, $this->conv('No.'), 'T', 0, 'C',1);
				$this->Cell($w_code, 8, $this->conv('商品コード'), 'T', 0, 'C',1);
				$this->Cell($w_item, 8, $this->conv('品目名'), 'T', 0, 'C',1);
				$this->Cell($w_quantity, 8, $this->conv('数量'), 'T', 0, 'C',1);
				$this->Cell($w_unit, 8, $this->conv('単価'), 'T', 0, 'C',1);
				$this->Cell($w_total, 8, $this->conv('合計'), 'T', 0, 'C',1);
				$i = 0;
				$page_num = 30;
			}

			//2ページ以上の最後のページ
			else if($_pages > 1 && $j == $_pages - 1){
				$page_num = 30;
				$this->SetXY(18, 17);
				$this->SetFont(MINCHO,'B',8);
				$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
				$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
				$this->Cell($w_no, 8, $this->conv('No.'), 'T', 0, 'C',1);
				$this->Cell($w_code, 8, $this->conv('商品コード'), 'T', 0, 'C',1);
				$this->Cell($w_item, 8, $this->conv('品目名'), 'T', 0, 'C',1);
				$this->Cell($w_quantity, 8, $this->conv('数量'), 'T', 0, 'C',1);
				$this->Cell($w_unit, 8, $this->conv('単価'), 'T', 0, 'C',1);
				$this->Cell($w_total, 8, $this->conv('合計'), 'T', 0, 'C',1);


				$y = 208;

				if(!empty($_param['Quote']['DISCOUNT'])){
					$this->SetXY(123, $y);
					$this->SetFont(MINCHO,'B',8);
					$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
					$this->Cell(28, 6, $this->conv('　割引'), '1', 0, 'L',1);
					$this->SetFont(MINCHO,'',8);
					$this->SetFillColor(0xFF, 0xFF, 0xFF);

					if($_param['Quote']['DISCOUNT_TYPE'] == 0 ){
						$str = $_param['Quote']['DISCOUNT'] ? number_format($_param['Quote']['DISCOUNT'] ) .'%': '0';
					}elseif($_param['Quote']['DISCOUNT_TYPE'] == 1 ){
						$str = $_param['Quote']['DISCOUNT'] ? '▲'.number_format($_param['Quote']['DISCOUNT'] ) : '0';
					}else{
						$str ='';
					}

					$str = $this->conv($str);
					$this->Cell(39, 6, $str, 1, 0, 'R',1);
					$y = $y + 6;
				}
				$this->SetXY(123, $y);
				$this->SetFont(MINCHO,'B',8);
				$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
				$this->Cell(28, 6, $this->conv('　小計'), '1', 0, 'L',1);
				$this->SetFillColor(0xFF, 0xFF, 0xFF);
				$this->SetFont(MINCHO,'',8);
				$str = $_param['Quote']['SUBTOTAL'] ? number_format($_param['Quote']['SUBTOTAL']) : '0';
				$str = $this->conv($str);
				$this->Cell(39, 6, $str, 1, 0, 'R',1);
				$y = $y + 6;

				$this->SetXY(123, $y);
				$this->SetFont(MINCHO,'B',8);
				$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
				$this->Cell(28, 6, $this->conv('　消費税'), '1', 0, 'L',1);
				$this->SetFillColor(0xFF, 0xFF, 0xFF);
				$this->SetFont(MINCHO,'',8);
				$str = $_param['Quote']['SALES_TAX'] ? number_format($_param['Quote']['SALES_TAX']) : '0';
				$str = $this->conv($str);
				$this->Cell(39, 6, $str, 1, 0, 'R',1);
				$y = $y + 6;

				$this->SetXY(123, $y);
				$this->SetFont(MINCHO,'B',8);
				$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
				$this->Cell(28, 6, $this->conv('　合計'), '1', 0, 'L',1);
				$this->SetFillColor(0xFF, 0xFF, 0xFF);
				$this->SetFont(MINCHO,'',8);
				$str = $_param['Quote']['TOTAL'] ? number_format($_param['Quote']['TOTAL']) : '0';
				$str = $this->conv($str);
				$this->Cell(39, 6, $str, 1, 0, 'R',1);
				$y = $y + 4;

				//備考欄
				$this->SetXY(18, $y);
				$this->SetFont(MINCHO,'B',9);
				$str = "備考欄";
				$str = $this->conv($str);
				$this->Write(5, $str);
				$y = $y + 5;


				$this->SetFont(MINCHO,'',9);
				$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
				$this->SetXY(18, $y);
				$str = $_param['Quote']['NOTE'];
				$str = $this->conv($str);
				$this->Cell( 172, 25, '', 1, 1, 'C');
				$this->SetXY(18, $y+1);
				$this->MBMultiCell(172, 4, $str, 0, 'L');


			}

			//2ページ以上の途中のページ
			else {
				$page_num = 40;
				$this->SetXY(18, 17);
				$this->SetFont(MINCHO,'B',8);
				$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
				$this->SetFillColor($column_color['R'],$column_color['G'],$column_color['B']);
				$this->Cell($w_no, 8, $this->conv('No.'), 'T', 0, 'C',1);
				$this->Cell($w_code, 8, $this->conv('商品コード'), 'T', 0, 'C',1);
				$this->Cell($w_item, 8, $this->conv('品目名'), 'T', 0, 'C',1);
				$this->Cell($w_quantity, 8, $this->conv('数量'), 'T', 0, 'C',1);
				$this->Cell($w_unit, 8, $this->conv('単価'), 'T', 0, 'C',1);
				$this->Cell($w_total, 8, $this->conv('合計'), 'T', 0, 'C',1);
			}

			$this->SetFont(MINCHO,'',8);

			for($rows=0 ; $rows < $page_num ; $i++){

				if($j == 0){
					if($rows % 2 == 0) {
						$this->SetXY(18, 99 + $rows * 6 + 0.5);
						$this->SetFillColor(0xFF, 0xFF, 0xFF);
						$height = 5.5;
						$border = "";

					}else {
						$this->SetXY(18, 99 + $rows * 6);
						$this->SetFillColor($row_color['R'],$row_color['G'],$row_color['B']);
						$this->SetDrawColor($column_color['R'],$column_color['G'],$column_color['B']);
						$height = 6;
						$border = "TB";
					}

				}
				else{
					if($rows % 2 == 0) {
						$this->SetXY(18, 25 + $rows * 6 + 0.5);
						$this->SetFillColor(0xFF, 0xFF, 0xFF);
						$height = 5.5;
						$border = "";

					}else {
						$this->SetXY(18, 25 + $rows * 6);
						$this->SetFillColor($row_color['R'],$row_color['G'],$row_color['B']);
						$this->SetDrawColor($column_color['R'],$column_color['G'],$column_color['B']);
						$height = 6;
						$border = "TB";
					}


				}


				//No.
				$str = isset($_param[$i]['Quoteitem']['ITEM_NO'])?$_param[$i]['Quoteitem']['ITEM_NO']:'';
				$str = $this->conv($str);
				$this->Cell($w_no, $height, $str, $border, 0, 'C',1);

				//商品コード
				$str = isset($_param[$i]['Quoteitem']['ITEM_CODE'])?$_param[$i]['Quoteitem']['ITEM_CODE']:'';
				$str = $this->conv($str);
				$this->Cell($w_code, $height, $str, $border, 0, 'C',1);

				//品目名
				$str = isset($_param[$i]['Quoteitem']['ITEM'])?$_param[$i]['Quoteitem']['ITEM']:'';
				$str = $this->conv($str);
				$this->Cell($w_item, $height, $str, $border, 0, 'L',1);

				//数量
				$str = isset($_param[$i]['Quoteitem']['QUANTITY']) && isset($_param[$i]['Quoteitem']['UNIT'])&& $_param[$i]['Quoteitem']['QUANTITY']?$this->ht2br($_param[$i]['Quoteitem']['QUANTITY'],null,'QUANTITY').$_param[$i]['Quoteitem']['UNIT']:'';
				$str = $this->conv($str);
				$this->Cell($w_quantity, $height, $str, $border, 0, 'C',1);

				//単価
				$str = '';
				if(isset($_param[$i]['Quoteitem']['TAX_CLASS']) && $_param[$i]['Quoteitem']['TAX_CLASS']%10 == 1) $str = '(内)';
				if(isset($_param[$i]['Quoteitem']['TAX_CLASS']) && $_param[$i]['Quoteitem']['TAX_CLASS']%10 == 3) $str = '(非)';

				$str .= isset($_param[$i]['Quoteitem']['UNIT_PRICE']) && $_param[$i]['Quoteitem']['UNIT_PRICE'] ? $this->ht2br($_param[$i]['Quoteitem']['UNIT_PRICE'],null,'UNIT_PRICE'):'';
				$str = $this->conv($str);
				$this->Cell($w_unit, $height, $str, $border, 0, 'R',1);


				//合計
				$str = isset($_param[$i]['Quoteitem']['AMOUNT']) && $_param[$i]['Quoteitem']['AMOUNT'] ? number_format($_param[$i]['Quoteitem']['AMOUNT']):'';
				$str = $this->conv($str);
				$this->Cell($w_total, $height, $str, $border, 0, 'R',1);

				$rows++;

				if($j == 0){
					if($rows % 2 == 0) {
						$this->SetXY(18, 99 + $rows * 6 + 0.5);
						$this->SetFillColor(0xFF, 0xFF, 0xFF);
						$height = 5.5;
						$border = "";
					}else {
						$this->SetXY(18, 99 + $rows * 6);
						$this->SetFillColor($row_color['R'],$row_color['G'],$row_color['B']);
						$this->SetDrawColor($column_color['R'],$column_color['G'],$column_color['B']);
						$height = 6;
						$border = "TB";
					}
				}

				else{
					if($rows % 2 == 0) {
						$this->SetXY(18, 25 + $rows * 6 + 0.5);
						$this->SetFillColor(0xFF, 0xFF, 0xFF);
						$height = 5.5;
						$border = "";
					}else {
						$this->SetXY(18, 25 + $rows * 6);
						$this->SetFillColor($row_color['R'],$row_color['G'],$row_color['B']);
						$this->SetDrawColor($column_color['R'],$column_color['G'],$column_color['B']);
						$height = 6;
						$border = "TB";
					}
				}

				if(isset($_param[$i]['Quoteitem']['DISCOUNT']) && $_param[$i]['Quoteitem']['DISCOUNT']){

					//No.
					$str = '';
					$str = $this->conv($str);
					$this->Cell($w_no, $height, $str, $border, 0, 'C',1);

					//品目名
					$str = '割引';
					$str = $this->conv($str);
					$this->Cell($w_item, $height, $str, $border, 0, 'L',1);

					//数量
					$str = '';
					$str = $this->conv($str);
					$this->Cell($w_quantity, $height, $str, $border, 0, 'C',1);

					//単価
					//				$str = $_param[$i]['Quoteitem']['DISCOUNT'].($_param[$i]['Quoteitem']['DISCOUNT_TYPE']==1?'円':'％');
					$str = $_param[$i]['Quoteitem']['DISCOUNT_TYPE']==1?'':$_param[$i]['Quoteitem']['DISCOUNT'].'%';
					$str = $this->conv($str);
					$this->Cell($w_unit, $height, $str, $border, 0, 'R',1);

					//合計
					$str = '▲'.number_format($_param[$i]['Quoteitem']['DISCOUNT_TYPE']==0?$_param[$i]['Quoteitem']['AMOUNT']*($_param[$i]['Quoteitem']['DISCOUNT']*0.01):$_param[$i]['Quoteitem']['DISCOUNT']);
					$str = $this->conv($str);
					$this->Cell($w_total, $height, $str, $border, 0, 'R',1);
					$amount-=($_param[$i]['Quoteitem']['DISCOUNT_TYPE']==0?$_param[$i]['Quoteitem']['AMOUNT']*($_param[$i]['Quoteitem']['DISCOUNT']*0.01):$_param[$i]['Quoteitem']['DISCOUNT']);
					$item_count++;
					$rows++;
				}
				$item_count++;
			}

			if($_pages == 1 && $j == 0){
				$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
				$this->Line(18 + $w_no, 92, 18 + $w_no, 219);
				$this->Line(18 + $w_no + $w_code, 92, 18 + $w_no + $w_code, 219);
				$this->Line(18 + $w_no + $w_code + $w_item, 92, 18 + $w_no + $w_code + $w_item, 219);
				$this->Line(18 + $w_no + $w_code + $w_item + $w_quantity, 92, 18 + $w_no + $w_code + $w_item + $w_quantity, 219);
				$this->Line(18 + $w_no + $w_code + $w_item + $w_quantity + $w_unit, 92, 18 + $w_no + $w_code + $w_item + $w_quantity + $w_unit, 219);
			}else if($_pages > 1 && $j == 0){
				$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
				$this->Line(18 + $w_no, 92, 18 + $w_no, 279);
				$this->Line(18 + $w_no + $w_code, 92, 18 + $w_no + $w_code, 279);
				$this->Line(18 + $w_no + $w_code + $w_item, 92, 18 + $w_no + $w_code + $w_item, 279);
				$this->Line(18 + $w_no + $w_code + $w_item + $w_quantity, 92, 18 + $w_no + $w_code + $w_item + $w_quantity, 279);
				$this->Line(18 + $w_no + $w_code + $w_item + $w_quantity + $w_unit, 92, 18 + $w_no + $w_code + $w_item + $w_quantity + $w_unit, 279);
			}else if($_pages > 1 && $j == $_pages - 1){
				$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
				$this->Line(18 + $w_no, 17, 18 + $w_no, 205);
				$this->Line(18 + $w_no + $w_code, 17, 18 + $w_no + $w_code, 205);
				$this->Line(18 + $w_no + $w_code + $w_item, 17, 18 + $w_no + $w_code + $w_item, 205);
				$this->Line(18 + $w_no + $w_code + $w_item + $w_quantity, 17, 18 + $w_no + $w_code + $w_item + $w_quantity, 205);
				$this->Line(18 + $w_no + $w_code + $w_item + $w_quantity + $w_unit, 17, 18 + $w_no + $w_code + $w_item + $w_quantity + $w_unit, 205);
			}else {
				$this->SetDrawColor($line_color['R'],$line_color['G'],$line_color['B']);
				$this->Line(18 + $w_no, 17, 18 + $w_no, 265);
				$this->Line(18 + $w_no + $w_code, 17, 18 + $w_no + $w_code, 265);
				$this->Line(18 + $w_no + $w_code + $w_item, 17, 18 + $w_no + $w_code + $w_item, 265);
				$this->Line(18 + $w_no + $w_code + $w_item + $w_quantity, 17, 18 + $w_no + $w_code + $w_item + $w_quantity, 265);
				$this->Line(18 + $w_no + $w_code + $w_item + $w_quantity + $w_unit, 17, 18 + $w_no + $w_code + $w_item + $w_quantity + $w_unit, 265);
			}


			if($j != $_pages - 1) $this->AddPage();


		}

	}

	//フッター
	function Footer()
	{
			$this->setXY(100,290);

			$this->SetFont(MINCHO,'',9);
			$str = $this->PageNo().'/'.$this->Total_Page;
			$str = mb_convert_encoding($str, "SJIS");
			$this->Write(3,$str);
	}
}